/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.integration.quark;

import azmalent.cuneiform.common.event.FuelHandler;
import azmalent.cuneiform.lib.compat.ModProxyImpl;
import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.cuneiform.lib.util.DataUtil;
import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.client.event.ColorHandler;
import azmalent.terraincognita.common.integration.quark.BasketDropIn;
import azmalent.terraincognita.common.integration.quark.IQuarkIntegration;
import azmalent.terraincognita.common.integration.quark.QuarkWoodBlockSet;
import azmalent.terraincognita.common.integration.quark.block.TIHedgeBlock;
import azmalent.terraincognita.common.integration.quark.block.TILeafCarpetBlock;
import azmalent.terraincognita.common.integration.quark.block.TIWoodPostBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModRecipes;
import azmalent.terraincognita.common.registry.ModWoodTypes;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.module.BurnVinesModule;
import vazkii.quark.content.client.module.ChestSearchingModule;
import vazkii.quark.content.tweaks.module.SignEditingModule;

@ModProxyImpl(value="quark")
public class QuarkIntegration
implements IQuarkIntegration {
    private static final ResourceLocation BASKET_DROP_IN_CAP = TerraIncognita.prefix("basket_drop_in");
    private final QuarkWoodBlockSet APPLE = new QuarkWoodBlockSet(ModWoodTypes.APPLE);
    private final BlockEntry BLOSSOMING_APPLE_LEAF_CARPET = ModBlocks.HELPER.newBuilder("blossoming_apple_leaf_carpet", TILeafCarpetBlock::new).cutoutMippedRender().build();
    private final BlockEntry BLOSSOMING_APPLE_HEDGE = ModBlocks.HELPER.newBuilder("blossoming_apple_hedge", () -> new TIHedgeBlock(MaterialColor.field_193562_N)).cutoutMippedRender().build();
    private final QuarkWoodBlockSet HAZEL = new QuarkWoodBlockSet(ModWoodTypes.HAZEL);
    private final BlockEntry HAZELNUT_SACK = ModBlocks.HELPER.newBuilder("hazelnut_sack", AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151650_B).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g)).build();
    private final BlockEntry SOUR_BERRY_SACK = ModBlocks.HELPER.newBuilder("sour_berry_sack", RotatedPillarBlock::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_193562_N).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g)).build();
    private final BlockEntry REEDS_BUNDLE = ModBlocks.HELPER.newBuilder("reeds_block", RotatedPillarBlock::new, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a)).withItemGroup(ItemGroup.field_78030_b).build();
    private final List<QuarkWoodBlockSet> WOOD_BLOCK_SETS = Lists.newArrayList((Object[])new QuarkWoodBlockSet[]{this.APPLE, this.HAZEL});

    @Override
    public boolean matchesItemSearch(ItemStack stack) {
        return ChestSearchingModule.namesMatch((ItemStack)stack);
    }

    public void register(IEventBus bus) {
        TerraIncognita.LOGGER.info("Integrating with Quark...");
        bus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::onAttachItemCapabilities);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(this::registerBlockColorHandlers);
            bus.addListener(this::registerItemColorHandlers);
        });
    }

    public void setup(FMLCommonSetupEvent event) {
        for (QuarkWoodBlockSet set : this.WOOD_BLOCK_SETS) {
            TIWoodPostBlock post = (TIWoodPostBlock)set.POST.getBlock();
            post.strippedBlock = set.STRIPPED_POST.getBlock();
            DataUtil.registerFlammable((BlockEntry)set.VERTICAL_PLANKS, (int)5, (int)20);
            DataUtil.registerFlammable((BlockEntry)set.BOOKSHELF, (int)30, (int)20);
            DataUtil.registerFlammable((BlockEntry)set.POST, (int)5, (int)20);
            DataUtil.registerFlammable((BlockEntry)set.STRIPPED_POST, (int)5, (int)20);
            DataUtil.registerFlammable((BlockEntry)set.HEDGE, (int)5, (int)20);
            DataUtil.registerFlammable((BlockEntry)set.LEAF_CARPET, (int)30, (int)60);
            FuelHandler.registerFuel((IItemProvider)set.VERTICAL_PLANKS, (int)300);
            FuelHandler.registerFuel((IItemProvider)set.BOOKSHELF, (int)300);
            FuelHandler.registerFuel((IItemProvider)set.LADDER, (int)300);
            FuelHandler.registerFuel((IItemProvider)set.POST, (int)300);
            FuelHandler.registerFuel((IItemProvider)set.STRIPPED_POST, (int)300);
            ModRecipes.registerCompostable((IItemProvider)set.LEAF_CARPET, 0.2f);
        }
        DataUtil.registerFlammable((BlockEntry)this.BLOSSOMING_APPLE_HEDGE, (int)5, (int)20);
        DataUtil.registerFlammable((BlockEntry)this.BLOSSOMING_APPLE_LEAF_CARPET, (int)30, (int)60);
        DataUtil.registerFlammable((BlockEntry)this.HAZELNUT_SACK, (int)30, (int)60);
        DataUtil.registerFlammable((BlockEntry)this.SOUR_BERRY_SACK, (int)30, (int)60);
        DataUtil.registerFlammable((BlockEntry)this.REEDS_BUNDLE, (int)30, (int)60);
        FuelHandler.registerFuel((IItemProvider)this.REEDS_BUNDLE, (int)900);
        ModRecipes.registerCompostable((IItemProvider)this.BLOSSOMING_APPLE_LEAF_CARPET, 0.2f);
        ModRecipes.registerCompostable((IItemProvider)this.SOUR_BERRY_SACK, 1.0f);
        ModRecipes.registerCompostable((IItemProvider)this.HAZELNUT_SACK, 1.0f);
        ModRecipes.registerCompostable((IItemProvider)this.REEDS_BUNDLE, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockColorHandlers(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.func_186722_a((state, reader, pos, color) -> 7589140, new Block[]{this.APPLE.LEAF_CARPET.getBlock(), this.BLOSSOMING_APPLE_LEAF_CARPET.getBlock(), this.APPLE.HEDGE.getBlock(), this.BLOSSOMING_APPLE_HEDGE.getBlock()});
        colors.func_186722_a((state, reader, pos, color) -> 3580188, new Block[]{this.HAZEL.LEAF_CARPET.getBlock(), this.HAZEL.HEDGE.getBlock()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColorHandlers(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        ColorHandler.registerDefaultItemColors(colors, event.getBlockColors(), new IItemProvider[]{this.APPLE.LEAF_CARPET, this.BLOSSOMING_APPLE_LEAF_CARPET, this.APPLE.HEDGE, this.BLOSSOMING_APPLE_HEDGE, this.HAZEL.LEAF_CARPET, this.HAZEL.HEDGE});
    }

    public void onAttachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == ModBlocks.BASKET.getItem()) {
            event.addCapability(BASKET_DROP_IN_CAP, (ICapabilityProvider)new BasketDropIn());
        }
    }

    @Override
    public boolean canEditSign(ItemStack heldStack) {
        return ModuleLoader.INSTANCE.isModuleEnabled(SignEditingModule.class) && (!SignEditingModule.requiresEmptyHand || heldStack.func_190926_b());
    }

    @Override
    public boolean canLanternConnect(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)LanternBlock.field_220278_a) != false && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof TIWoodPostBlock;
    }

    @Override
    public boolean canBurnVineTips() {
        return ModuleLoader.INSTANCE.isModuleEnabled(BurnVinesModule.class);
    }
}

